/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.terminal.connector;

import com.aptana.terminal.connector.IOutputFilter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;

class LocalTerminalOutputListener
implements IStreamListener {
    private PrintStream printStream;
    private IOutputFilter outputFilter;
    private boolean hasOutput = false;

    protected LocalTerminalOutputListener(ITerminalControl control, IOutputFilter outputFilter) throws UnsupportedEncodingException {
        this.printStream = new PrintStream(control.getRemoteToTerminalOutputStream(), true, "UTF-8");
        this.outputFilter = outputFilter;
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        if (this.outputFilter != null) {
            text = String.valueOf(this.outputFilter.filterOutput(text.toCharArray()));
            this.printStream.print(text);
        } else {
            this.printStream.print(text);
        }
        if (!this.hasOutput) {
            this.hasOutput = text.length() > 0;
        }
    }

    boolean hasOutput() {
        return this.hasOutput;
    }
}

